/**************************************************************************************

Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.

***************************************************************************************

  $Id: libc_file_support.h 4490 2020-08-13 13:32:21Z Robert $:

  Description:
    libc_file_support.h  Registration of debug output drivers for libc printf, etc.

  Changes:
    Date        Description
    -----------------------------------------------------------------------------------
    2006-12-07  initial version

**************************************************************************************/

/*****************************************************************************/
/*! \file libc_file_support.h                                                    
*   Registration of debug output drivers for libc printf, etc.               */
/*****************************************************************************/

#ifndef __LIBC_FILE_SUPPORT__H
#define __LIBC_FILE_SUPPORT__H

#define FILE_HANDLER_STDIN    0
#define FILE_HANDLER_STDOUT   1
#define FILE_HANDLER_STDERR   2
#define FILE_HANDLER_DEFAULT  3

#define READ_NO_DATA    -1

typedef void(*PFN_WRITE)(const void* pvBuffer, unsigned long ulSize, void* pvUser);
typedef int(*PFN_READ)(void* pvBuffer, unsigned long* pulSize, void* pvUser);

void libc_file_init();

void Libc_RegisterStdOutFileHook(int fError, PFN_WRITE pfnWrite, void* pvUser);
void Libc_RegisterStdInFileHook(PFN_READ pfnRead, void* pvUser);


#endif /* __LIBC_FILE_SUPPORT__H */
